﻿using System;
using System.Data;
using System.Web.UI.WebControls;

public partial class ReportUniqueIndividuals : BasePage
{
    bool batchReport = false;        

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        if (!IsPostBack)
        {
            Session["batchReport"] = SessionItemFactory.Create(batchReport.ToString());
            Session["EFRBatchPrintOptions"] = SessionItemFactory.Create(Helpers.GetCrsSetting("EFRBatchPrintOptions"));
            Session["EFRIndividualPrintOptions"] = SessionItemFactory.Create(Helpers.GetCrsSetting("EFRIndividualPrintOptions"));

            ClientScript.RegisterStartupScript(this.GetType(), "LoadPrintOptions", "window.onload=loadReportPrintOptions();");            

            // Bind our data
            try
            {
                GridViewUniqueIndividualsFiles.DataSource = GetUniqueIndividualsFiles();
                GridViewUniqueIndividualsFiles.DataBind();
                GridViewUniqueIndividualsFiles.Caption = "Number of Unique Individuals Screened Report";
                GridViewUniqueIndividualsFiles.CaptionAlign = TableCaptionAlign.Top;
            }
            catch (Exception exc)
            {
                Logging.WriteLogToFile("Error in ReportUniqueIndividuals.PageLoad()", exc);
            }
        }
    }
    
    private bool AccessAllowed()
    {
        return true;
    }
    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Referral Report";
    }

    public override string AppObjectCode()
    {
        return "EFR_UNIQUEINDIVIDUALS_REPORT";
    }

    public DataTable GetUniqueIndividualsFiles()
    {
        DataTable dataTable = new DataTable();

        dataTable = SqlProvider.ExecuteSPDataTable(
            "RegistryConnectionString",
            "dbo.usp_EFR_GetNumUniqueIndividuals",
            new object[] { });

        return dataTable;
    }

    protected void UniqueIndividuals_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {

    }

    protected void UniqueIndividuals_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewUniqueIndividualsFiles.DataSource = GetUniqueIndividualsFiles();
        GridViewUniqueIndividualsFiles.PageIndex = e.NewPageIndex;
        GridViewUniqueIndividualsFiles.DataBind();
    }
}
